<?xml version="1.0" encoding="UTF-8"?>
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" abstract="true" id="attentionLine">
    <title>Transmission wrapper AttentionLine validatie</title>
    <!-- attentionLine mag herhalen -->
    <!--attentionLine>
        <keyWordText code="PATID" codeSystem="2.16.840.1.113883.2.4.15.1">Patient.id</keyWordText>
        <value xsi:type="II"  root="2.16.840.1.113883.2.4.6.3" extension="555555112"/>
        </attentionLine-->
    
    <rule context="hl7:interactionId[preceding-sibling::hl7:creationTime and following-sibling::hl7:profileId[not(@extension='608' or @extension='705' or @extension='805')]]">
        <assert role="error" test="if ($attentionLineOptional='false') then (count(../hl7:attentionLine)=1) else (1=1)"
            >Er moet verplicht één attentionLine element zijn, welke de patiënt identificeert om wie dit bericht gaat.</assert>
        <assert role="error" test="if ($attentionLineOptional='true') then (count(../hl7:attentionLine)&lt;=1) else (1=1)"
            >Er mag optioneel één attentionLine element zijn, welke de patiënt identificeert om wie dit bericht gaat.</assert>
    </rule>
    
    <rule context="hl7:interactionId[preceding-sibling::hl7:creationTime and following-sibling::hl7:profileId[@extension='810']]">
        <assert role="warning" test="not(../hl7:attentionLine)"
            >In deze publicatie mag AttentionLine nog niet worden verstuurd, maar moeten ontvangers deze wel kunnen negeren. Deze interactie moet dus voor test of kwalificatiedoeleinden zijn opgesteld.</assert>
    </rule>
    
    <rule context="hl7:attentionLine[preceding-sibling::hl7:creationTime and preceding-sibling::hl7:interactionId and preceding-sibling::hl7:profileId[not(@extension='608' or @extension='705' or @extension='805')]]">
        <assert role="error" test="hl7:keyWordText"
            >attentionLine/keyWordText is verplicht</assert>
        <assert role="error" test="hl7:value"
            >attentionLine/value is verplicht</assert>
    </rule>
    <rule context="hl7:attentionLine[preceding-sibling::hl7:creationTime and preceding-sibling::hl7:interactionId and preceding-sibling::hl7:profileId[not(@extension='608' or @extension='705' or @extension='805')]]/hl7:keyWordText">
        <extends rule="SC"/>
        <let name="code" value="@code"/>
        <let name="codeSystem" value="@codeSystem"/>
        <let name="text" value=".[1]"/>
        <let name="vocabFile" value="concat('../vocab/',$codeSystem,'.xml')"/>
        <assert role="error" test="$codeSystem='2.16.840.1.113883.2.4.15.1' and document($vocabFile)/*/hl7:code[@code=$code][@codeSystem=$codeSystem]"
            >attentionLine/keyWordText moet een geldige code uit codesysteem '2.16.840.1.113883.2.4.15.1' bevatten</assert>
        <assert role="error" test="not(@code='PATID') or $text='Patient.id'"
            >attentionLine/keyWordText moet de waarde 'Patient.id' bevatten als @code='PATID'</assert>
        <assert role="error" test="not(@code='FICID') or $text='FictiefPatientnummer'"
            >attentionLine/keyWordText moet de waarde 'FictiefPatientnummer' bevatten als @code='FICID'</assert>
    </rule>
    <rule context="hl7:attentionLine[preceding-sibling::hl7:creationTime and preceding-sibling::hl7:interactionId and preceding-sibling::hl7:profileId[not(@extension='608' or @extension='705' or @extension='805')]]/hl7:value">
        <extends rule="II"/>
        <assert role="error" test="not(preceding-sibling::hl7:keyWordText='Patient.id') or @root='2.16.840.1.113883.2.4.6.3'"
            >attentionLine/value moet een burgerservicenummer bevatten met OID '2.16.840.1.113883.2.4.6.3'</assert>
    </rule>

    <rule context="$messagePatientId">
        <let name="patRoot" value="@root"/>
        <let name="patExt" value="@extension"/>
        <assert role="error" test="not(ancestor::*/hl7:attentionLine) or ancestor::*/hl7:attentionLine/hl7:value[@extension=$patExt and @root=$patRoot]"
            >De patiënt in de Payload (BSN '<value-of select="$patExt"/>') moet overeen komen met de patient in de attentionLine (BSN '<value-of
                select="ancestor::*/hl7:attentionLine/hl7:value/@extension"/>')</assert>
    </rule>
</pattern>
